/* Addendum to oSIP library
** Copyright (c) 2006
** Siemens Home and Office Communication Devices GmbH & Co. KG (SHC)
** http://gigaset.siemens.com

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef OSIP_CONFIG_H
 #define OSIP_CONFIG_H

#define SHC 1 /*mark as SHC portation*/

//***** Includes ***********************************************************

//***** Defines and Enums **************************************************

// first UN-DEFINE some environment variables.
#undef  ENABLE_TRACE
#undef  SYSTEM_LOGGER_ENABLED

// oSIP library configuration

#if SHC
  #define SHC_OSIP_ENABLE_MSG_PROPERTY 0

  #define SIP_MESSAGE_MAX_LENGTH 1500
  #define BODY_MESSAGE_MAX_SIZE  1500
#endif

#undef HAVE_ASSERT_H

// Define to 1 if you have the <assert.h> header file. 
#undef HAVE_ASSERT_H

// Define to 1 if you have the <ctype.h> header file. 
#define HAVE_CTYPE_H 1

// Define to 1 if you have the <dlfcn.h> header file. 
#undef HAVE_DLFCN_H

// Define to 1 if you have the <fcntl.h> header file. 
#undef HAVE_FCNTL_H

// Define to 1 if you have the <inttypes.h> header file. 
#define HAVE_INTTYPES_H 1

// Defined if you have lrand48 
#undef HAVE_LRAND48

// Define to 1 if you have the <malloc.h> header file. 
#undef HAVE_MALLOC_H

// Define to 1 if you have the <memory.h> header file. 
#undef HAVE_MEMORY_H

// Define if you have POSIX threads libraries and header files. 
#undef HAVE_PTHREAD

// Define to 1 if you have the <semaphore.h> header file. 
#undef HAVE_SEMAPHORE_H

// Define to 1 if you have the <signal.h> header file. 
#define HAVE_SIGNAL_H 1

// Define to 1 if you have the <stdarg.h> header file. 
#define HAVE_STDARG_H 1

// Define to 1 if you have the <stdint.h> header file.
#define HAVE_STDINT_H 1

// Define to 1 if you have the <stdio.h> header file.
#define HAVE_STDIO_H 1

// Define to 1 if you have the <stdlib.h> header file.
#define HAVE_STDLIB_H 1

// Define to 1 if you have the <strings.h> header file.
#undef HAVE_STRINGS_H

// Define to 1 if you have the <string.h> header file.
#define HAVE_STRING_H 1

// Define to 1 if you have the <syslog.h> header file.
#undef HAVE_SYSLOG_H

// Define to 1 if you have the <sys/select.h> header file.
#undef HAVE_SYS_SELECT_H

// Define to 1 if you have the <sys/sem.h> header file.
#undef HAVE_SYS_SEM_H

// Define to 1 if you have the <sys/signal.h> header file.
#undef HAVE_SYS_SIGNAL_H

// Define to 1 if you have the <sys/stat.h> header file.
#undef HAVE_SYS_STAT_H

// Define to 1 if you have the <sys/time.h> header file.
#undef HAVE_SYS_TIME_H

// Define to 1 if you have the <sys/types.h> header file.
#undef HAVE_SYS_TYPES_H

// Define to 1 if you have the <sys/unistd.h> header file.
#undef HAVE_SYS_UNISTD_H

// Define to 1 if you have the <time.h> header file.
#undef HAVE_TIME_H

// Define to 1 if you have the <unistd.h> header file.
#undef HAVE_UNISTD_H

// Define to 1 if you have the <varargs.h> header file.
#undef HAVE_VARARGS_H

// Name of package
#define PACKAGE "libosip2"

// Define to the address where bug reports for this package should be sent.
#define PACKAGE_BUGREPORT ""

// Define to the full name of this package.
#define PACKAGE_NAME ""

// Define to the full name and version of this package.
#define PACKAGE_STRING ""

// Define to the one symbol short name of this package.
#define PACKAGE_TARNAME ""

// Define to the version of this package.
#define PACKAGE_VERSION ""

// Define to the necessary symbol if this constant uses a non-standard name on
// your system.
// #undef PTHREAD_CREATE_JOINABLE

// Define to 1 if you have the ANSI C header files.
#define STDC_HEADERS 1

// Version number of package
#define VERSION "2.2.2"

#include <sc/open_src/osip_adap/libosip_openlib.h>

#endif // OSIP_CONFIG_H
