/* == IDENTIFICATION ==========================================================
 *
 * Copyright (c) 2008, DSP Group Nuernberg
 *
 * System           : Vega Family
 * Component        : all
 * Module           : SSW
 * Unit             : Global Type Defintions
 *
 * @(#) %filespec: cg0type.h-29 %
 */

/* == HISTORY =================================================================
 *
 * Name         Date     Ver  Action
 * ----------------------------------------------------------------------------
 * tcmc_asb  16-Oct-2009  29  prevent double uint typedef
 * tcmc_asb   2-Mar-2009  28  merging D46 - D51
 * tcmc_asb  11-Feb-2009  27  changes for Dx -> DCX
 * tcmc_asb  28-Jan-2009  26  consider Dx
 * yanivso   03-Dec-2008  25_D52 Dx initial integration
 * tcmc_asb   6-Oct-2008  25  do without prj_printf
 *                           (controlled now by EMBEDDED_PRINTF, see embedded.c)
 * tcmc_mhs  19-mar-2008  24  CR475: INLINE for IAR toolchain 
 * tcmc_asb   7-Feb-2008  23  volatile, MIN, MAX, ABS
 * tcmc_mld  29-Jan-2008  22  different u64, s64 typedefs for Visual C++ needed
 * tcmc_asb  21-Mar-2007  21  u64, s64
 * tcmc_asb  31-Jan-2007  20  D51 version aligned with D46
 * tcmc_asb  18-Dec-2006  19  DELAY_LOOP to avoid inline assembler NOPs
 * tcmc_ore  34-Jul-2006  18  workaround realview volatile bug (this does exist
 *                            at least in 2.2 [Build 435 and 576]
 * tcmc_asb  27-Mar-2006  17  prj_printf for ARM RV
 * tcmc_asb   3-Mar-2005  15  C++ proof
 * tcmc_asb  20-Aug-2004  13  ADS1.1 workaround for __arm builds only
 * tcmc_asb  10-Nov-2003  12  revert to -11 (continue to use int instead
 *                            of long for u32/s32)
 * tcmc_asb  20-Oct-2003  11  remove typecasts from prj_ prototypes
 * tcmc_asb  16-Oct-2003  10  ALIGNi, PTR2INT(p)
 * tcmc_asb   6-Feb-2002   8  VOLAT_U16, ..
 * tcmc_asb  03-Mai-2001   7  workaround ADS1.1 optimizer bug
 * tcmc_mhs  08-dec-2000      added ARR_U8, ..
 * tcmc_mhs  04-dec-2000      removing: DSP_FILES_NOK, adding: uint, dsp_uint
 * tcmc_asb  10-Mar-2000      added guard against multiple inclusion
 * tcmc_asb  02-Mar-2000      Created (copy from D46)
 *
 */

/*MPM==========================================================================
 *
 * ABSTRACT:
 *
 * This module declares global types used throughout the system
 *
 *
 * Global functions to be called by other modules:
 * -----------------------------------------------
 * - None
 *
 * Module functions to be called by other units:
 * ---------------------------------------------
 * - None
 *
 * Unit functions to be called only by this unit:
 * ----------------------------------------------
 * - None
 *
 */

/* == DECLARATION OF TYPES ================================================= */

#ifndef cg0type_h
#define cg0type_h

/* unsigned int [0,255] */
typedef unsigned char                     u8;

/* unsigned int [0,65535] */
typedef unsigned short                   u16;

/* unsigned int [0,4294967295] */
typedef unsigned int                     u32;

/* unsigned int [0, 18446744073709551616] */
#ifdef _MSC_VER
/* this is for Microsoft, e.g. Visual C++ (no long long)  */
typedef unsigned __int64  u64;
#else
typedef unsigned long long               u64;
#endif

/* signed int [-128,127] */
typedef signed char                       s8;

/* signed int [-32768,32767] */
typedef signed short                     s16;

/* signed int [-2147483648, 2147483647] */
typedef signed int                       s32;

/* signed int [-9223372036854775808, 9223372036854775807] */
#ifdef _MSC_VER
/* this is for Microsoft, e.g. Visual C++ (no long long)  */
typedef signed __int64                   s64;
#else
typedef long long                        s64;
#endif

typedef char * t_cg0_Curious;
#define PV2INT(ptr)     (((t_cg0_Curious)(ptr)) - (t_cg0_Curious)0)
#define INT2PV(i)       ((void *)&((t_cg0_Curious)0)[i])

#if __ARMCC_VERSION >= 220000 // ARV2.2 and later
#define VOLATILE(x,type) (*(volatile type*)(((u32)&(x))))
#define VOLAT_U8(x)      (*(volatile u8  *)(((u32)&(x))))
#define VOLAT_S8(x)      (*(volatile s8  *)(((u32)&(x))))
#define VOLAT_U16(x)     (*(volatile u16 *)(((u32)&(x))))
#define VOLAT_S16(x)     (*(volatile s16 *)(((u32)&(x))))
#define VOLAT_U32(x)     (*(volatile u32 *)(((u32)&(x))))
#define VOLAT_S32(x)     (*(volatile s32 *)(((u32)&(x))))
#else
#define VOLATILE(x,type) (*(volatile type*)(&(x)))
#define VOLAT_U8(x)      (*(volatile u8  *)(&(x)))
#define VOLAT_S8(x)      (*(volatile s8  *)(&(x)))
#define VOLAT_U16(x)     (*(volatile u16 *)(&(x)))
#define VOLAT_S16(x)     (*(volatile s16 *)(&(x)))
#define VOLAT_U32(x)     (*(volatile u32 *)(&(x)))
#define VOLAT_S32(x)     (*(volatile s32 *)(&(x)))
#endif
#define ARR_U8(lval)       ((u8 *)(&(lval)))  // cast lval to u8  array
#define ARR_U16(lval)     ((u16 *)(&(lval)))  // cast lval to u16 array
#define ARR_U32(lval)     ((u32 *)(&(lval)))  // cast lval to u32 array
#define ARR_S8(lval)       ((s8 *)(&(lval)))  // cast lval to s8  array
#define ARR_S16(lval)     ((s16 *)(&(lval)))  // cast lval to s16 array
#define ARR_S32(lval)     ((s32 *)(&(lval)))  // cast lval to s32 array


#ifdef __CC_ARM                 // ADS or RealView

# define ALIGN2 __align(2)
# define ALIGN4 __align(4)
# define ALIGN8 __align(8)
# define INLINE __inline
# define WEAK   __weak
# define PURE   __pure // for prototypes of funcs which operate on locals only
# define XPARAM __value_in_regs // pass/return structs in registers

#elif defined __ICCARM__        // IAR

# define ALIGN2
# define ALIGN4
# define ALIGN8
# define INLINE inline
# define WEAK
# define PURE
# define XPARAM

#else                           // e.g. GNU

# define ALIGN2
# define ALIGN4
# define ALIGN8
# define INLINE
# define WEAK
# define PURE
# define XPARAM

#endif


#ifndef _SYS_TYPES_H
//  just an abbreviation
typedef unsigned int uint;
#endif

//  must be >= 16 bit, whatever is best to be handled by ARM
typedef unsigned int dsp_uint;


#define DELAY_LOOP(n) {u32 i; for (VOLAT_U32(i)=n; VOLAT_U32(i); VOLAT_U32(i)--);} // min n*4 cycles

#ifndef MIN
#define MIN(a,b)    (((a)<(b))?(a):(b))
#endif
#ifndef MAX
#define MAX(a,b)    (((a)>(b))?(a):(b))
#endif
#ifndef ABS
#define ABS(a)      (((a)<(0))?-(a):(a))
#endif


#if defined(VegaOne) || defined(DCX)

  //  workaround for REAL access not needed here

  //  fix string.s to access _aeabi_mem_ functions before
  //  using prj_ functions for VegaFireBird

  #include <string.h>

#else

#ifdef __cplusplus
#  define CPP_COMPAT_START extern "C" {
#  define CPP_COMPAT_END   }
#else
#  define CPP_COMPAT_START
#  define CPP_COMPAT_END
#endif

#ifdef __CC_ARM
// prj_   functions as workaround for ADS1.1 optimizer bug
//                 (tcc treats string func as pure - sometimes)
// p_da_  functions handle access restrictions of DSP memory (no byte access)
#include <string.h>

CPP_COMPAT_START

extern void *p_da_memset (void * dest, int value, size_t size);
extern void *p_da_memcpy (void * dest, const void * source, size_t size);
extern void *p_da_memmove(void * dest, const void * source, size_t size);
extern char *prj_strcpy  (char * dest, const char * source);
extern char *prj_strncpy (char * dest, const char * source, size_t size);

CPP_COMPAT_END

#define  memcpy(dest, src, len)  p_da_memcpy (dest, src, len)
#define memmove(dest, src, len)  p_da_memmove(dest, src, len)
#define  memset(dest, val, len)  p_da_memset (dest, val, len)
#define  strcpy(dest, src)        prj_strcpy (dest, src)
#define strncpy(dest, src, len)   prj_strncpy(dest, src, len)
#endif // __CC_ARM

#endif  //  #ifdef VegaOne || DCX

#endif //cg0type_h

/*eof*/
