//MH******************   Copyright (c) by SIEMENS AG   ********************
/** \file     iksemel_main.c
 *  \author   owner: Siegelth 
 *  \brief    fast compile file of iksemel library
 *  
 *            ### Multi line detailed description
 *  \note     Special Cases: ###
 *************************************************************************/
                    
/*lint -e766*/

//***** Module Specific Defines and Enums *********************************
#define HAVE_CONFIG_H 1

//***** includes **********************************************************

#include <app_bs/iksemel/include/common.h>
#include <app_bs/iksemel/include/iksemel.h>
#include <app_bs/iksemel/shc/iksemel_string.h>
#include <app_bs/iksemel/iksemel.cfg>

#if IKSEMEL_LIB_ENA

/** \addtogroup IKSEMEL_MAIN
  * \ingroup IKSEMEL_LIB
  * @{ */

//***** Module Specific Macros and Typedefs *******************************

//***** Definition of Global Variables  ***********************************

//***** Definition of Static Variables ************************************

//***** Prototypes of Static Functions ************************************

//*************************************************************************

//*************************************************************************

#ifdef ZIELSIM
  #pragma message ("--------------- Compile ---------------")
#endif

#if HAS_BASE64
  #ifdef ZIELSIM
    #pragma message ("compile: BASE64.C")
  #endif
  #include <app_bs/iksemel/src/base64.c>
#endif

#if HAS_DOM
  #ifdef ZIELSIM
    #pragma message ("compile: DOM.C")
  #endif
  #include <app_bs/iksemel/src/dom.c>
#endif

#if HAS_FILTER
#ifdef ZIELSIM
  #pragma message ("compile: FILTER.C")
#endif
#include <app_bs/iksemel/src/filter.c>
#endif

#if HAS_IKS
#ifdef ZIELSIM
  #pragma message ("compile: IKS.C")
#endif
#include <app_bs/iksemel/src/iks.c>
#endif

#if HAS_IKSTACK
#ifdef ZIELSIM
  #pragma message ("compile: IKSTACK.C")
#endif
#include <app_bs/iksemel/src/ikstack.c>
#endif

#if HAS_JABBER
#ifdef ZIELSIM
  #pragma message ("compile: JABBER.C")
#endif
#include <app_bs/iksemel/src/jabber.c>
#endif

#if HAS_MD5
#ifdef ZIELSIM
  #pragma message ("compile: MD5.C")
#endif
#include <app_bs/iksemel/src/md5.c>
#endif

#if HAS_SAX
#ifdef ZIELSIM
  #pragma message ("compile: SAX.C")
#endif
#include <app_bs/iksemel/src/sax.c>
#endif

#if HAS_SHA
#ifdef ZIELSIM
  #pragma message ("compile: SHA.C")
#endif
#include <app_bs/iksemel/src/sha.c>
#endif

#if HAS_STREAM
#ifdef ZIELSIM
  #pragma message ("compile: STREAM.C")
#endif
#include <app_bs/iksemel/src/stream.c>
#endif

#if HAS_UTILITY
#ifdef ZIELSIM
  #pragma message ("compile: UTILITY.C")
#endif
#include <app_bs/iksemel/src/utility.c>
#endif

#endif

/** @} */
