/**MH**Copyright by SIEMENS AG, ICM CD DP RD12. All rights reserved *******
 * PROJEKT         : THEBO
 * Dateiname       : $Workfile:   STDTYP.H  $
 * Autor, Dst.     : UO, DP D 12
 *-------------------------------------------------------------------------
 * Funktion        : 
 * Besonderheiten  :
 *-------------------------------------------------------------------------
 *************************************************************************/

#ifndef STDTYP_H
  #define STDTYP_H                    


#ifndef  FALSE
  #define FALSE   0   
  #define TRUE    (!0)  // !0 ist besser als 1, da xxx==TRUE explizit
#endif                  // mit dem wert 1 vergleicht anstatt dem bool !=0
                        // ZIELSIM wird hier aber warning geben bei xxx==TRUE
                        // da dort kein datentyp bool existiert,
                        // if(xxx==TRUE) sollte eh nicht benutzt werden (JFO)
#ifndef NULL
  #define NULL 0
#endif


/* standard includes welche generel fur die type anderungen gemacht werden mussen */
#include <derivat.cfg>
//#include <target.h>
#include <string.h>


/* -------------------------------------------------------------- */
/*   Allgemeine Defines, sowohl fr Target als auch fr Zielsim   */
/* -------------------------------------------------------------- */
#define  VOID     void
#define  LONG     signed   long     // 4 Byte
#define  ULONG    unsigned long     // 4 Byte
#define  FLOAT    float
#define  STRING   char *
#define  UCHAR    unsigned char     // 1 Byte
#define  BITS     unsigned char     // 1 Byte
#define  WBITS    unsigned short    // 2 Byte
#define  uchar    unsigned char     
//#define  uint     unsigned int
                                    
/* Achtung: hiermit wird typedef ...  INT in windows.h ueberschrieben */
#define  INT      signed short      // 2 Byte
/* Achtung: hiermit wird typedef ... BOOL in windows.h ueberschrieben */
#define  BOOL     unsigned char     // 1 Byte
/* Achtung: hiermit wird typedef ... UINT in windows.h ueberschrieben */
#define  UINT     unsigned short    // 2 Byte

#ifndef NUL
  #define  NUL        '\0'
#endif

/* -------------------------------------------------------------- */
/*              Defines fuer den ARM-Compiler                     */
/* -------------------------------------------------------------- */
#if (defined(ARM7) || (defined(ARM9)))
                        
  #include <lib/string.arg>
                       
                        
// #define struct __packed struct
// #define union  __packed union

//  #define  memcpy(a,b,c) memcpy((void*)(a),(void*)(b),c)
//  #define  memmove(a,b,c) memmove((void*)(a),(void*)(b),c)
//  #define  memset(a,b,c) memset((void*)(a),b,c)
  #define  memcmp(a,b,c) memcmp((const void*)(a),(const void*)(b),c)


  #define  WORDALIGN      __align(4)
  #define  HALFWORDALIGN  __align(2)


  #define  SFR    unsigned char
  #define  SFR16  unsigned short
  #define  SBIT   unsigned char
  #define  BIT    unsigned char        // wie BOOL 
  #define  BITFLD unsigned char        // ARM Compiler hat keine Probleme hiermit

  #define  HUGE  
  #define  NEAR   
  #define  FAR    

  #define  CHAR   char
  #define  TEXT   unsigned char *    

  #define  REENTRANT  
  #define  INTERRUPT0 
  #define  INTERRUPT1 
  #define  INTERRUPT2 
  #define  INTERRUPT3 
  #define  INTERRUPT4 
  #define  INTERRUPT5 
  #define  INTERRUPT6 
  #define  INTERRUPT7

  #define  XDATA 
  #define  BDATA
  #define  PDATA 
  #define  IDATA 
  #define  DATA 
  #define  CODE         const

// ****************** _TODO_BEGIN_GZ_ ******************
// ** 
// packed have to be investigate
//  #define  PACKED       __packed
  #define  PACKED       
  #define  PACKED_STRUCT  __packed
// ** 
// ******************* _TODO_END_GZ_ *******************


  #define  KONST        const        

// GZ  #define  SWI(SwiNr)   __swi(SwiNr)

  #define VAR_PTR_TO_CONST_TYP(Datentyp)   CODE Datentyp *
  #define CONST_PTR_TO_CONST_TYP(Datentyp) CODE Datentyp * CODE
  #define CONST_PTR_TO_VAR_TYP(Datentyp)        Datentyp * CODE
  #define CONST_PTR_TO_XDATA(Datentyp)          Datentyp * CODE

  #define PRINTF(p)                   // fr Target PRINTF ausschalten

  #define U8_AUTO_VAR    unsigned long
  #define S8_AUTO_VAR    signed   long
  #define U16_AUTO_VAR   unsigned long
  #define S16_AUTO_VAR   signed   long

//  #if !WDCT
//    #define TEST_VR
//  #endif


/* -------------------------------------------------------------- */
/*              Defines fuer den IAR-Compiler                     */
/* -------------------------------------------------------------- */
#elif defined(IAR_CR16)


  #define  WORDALIGN
  #define  HALFWORDALIGN

  #define  SFR    unsigned char
  #define  SFR16  unsigned short
  #define  SBIT   unsigned char
  #define  BIT    unsigned char       // wie BOOL
  #define  BITFLD unsigned char       // wie bei Zielsim

  #define  NEAR   __near
  #define  FAR    __huge
  #define  HUGE   __huge

  #pragma pack(1)                   // byte alignment for struct/union


  #define  CHAR   char
  #define  TEXT   unsigned char *

  #define  REENTRANT  
  #define  INTERRUPT0 
  #define  INTERRUPT1 
  #define  INTERRUPT2 
  #define  INTERRUPT3 
  #define  INTERRUPT4 
  #define  INTERRUPT5 
  #define  INTERRUPT6 
  #define  INTERRUPT7

  #define  USING0
  #define  USING1
  #define  USING2
  #define  USING3

  #define  XDATA 
  #define  BDATA
  #define  PDATA 
  #define  IDATA 
  #define  DATA 
  #define  CODE         const

  #define  PACKED

  #define  KONST        const

  #define  SWI(SwiNr)


  #define VAR_PTR_TO_CONST_TYP(Datentyp)   CODE Datentyp *
  #define CONST_PTR_TO_CONST_TYP(Datentyp) CODE Datentyp * CODE
  #define CONST_PTR_TO_VAR_TYP(Datentyp)        Datentyp * CODE
  #define CONST_PTR_TO_XDATA(Datentyp)          Datentyp * CODE

  #define PRINTF(p)                   // fr Target PRINTF ausschalten

  #define U8_AUTO_VAR    unsigned char
  #define S8_AUTO_VAR    signed   char
  #define U16_AUTO_VAR   unsigned short
  #define S16_AUTO_VAR   signed   short

 
   
/* -------------------------------------------------------------- */
/*              Defines fr die Zielsimualtion                    */
/* -------------------------------------------------------------- */
#elif defined(ZIELSIM)

  #define  SBIT( reg, adr )   extern unsigned char reg;
  #define  SFR( reg, adr )    extern unsigned char reg;
  #define  SFR16( reg, adr )  extern unsigned int  reg;

  #define  BIT    unsigned char      // wie BOOL
  #define  BITFLD unsigned char


  #define  WORDALIGN
  #define  HALFWORDALIGN


  // FAR/NEAR werden in  windef.h schon wegdefiniert
  #ifndef FAR
    #define  FAR 
  #endif
  #ifndef NEAR
    #define  NEAR 
  #endif
  #ifndef HUGE
    #define  HUGE 
  #endif

  typedef   unsigned int  Z_UINT; // 16/32Bit wie win32/windef.h oder win16/windows.h
  typedef   int           Z_INT;  // 16/32Bit wie win32/windef.h oder win16/windows.h
  typedef   int           Z_BOOL; // wie in win16/windows.h, win32/windef.h 
/*                                   weil bei Windows-API-Funktionen manchmal 
 *                                   der original BOOL verwendet werden muss */
  #define  CHAR   char  
  #ifdef TEXT
    #undef  TEXT                  // dies ist ein 32Bit Macro (siehe UNICODE)
  #endif
  #define  TEXT  unsigned char *    

  #define  REENTRANT  
  #define  INTERRUPT0 
  #define  INTERRUPT1 
  #define  INTERRUPT2 
  #define  INTERRUPT3 
  #define  INTERRUPT4 
  #define  INTERRUPT5 
  #define  INTERRUPT6 
  #define  INTERRUPT7
  /*
		Klein buchstaben sind verboten unter der ARM code 
		da wird das zur probleme fuhren !!
		  #define  xdata 
		  #define  bdata
		  #define  pdata 
		  #define  idata 
		  #define  data 
		  #define  code 
  */
  #define  XDATA 
  #define  BDATA
  #define  PDATA 
  #define  IDATA 
  #define  DATA 
  #define  CODE       
  #define  KONST                    // Visual C++ doesn't like

  #define  PACKED       
  #define  PACKED_STRUCT

/*                                     'const' inside struct .. (LC) */

  #define  SWI(SwiNr)
  
  #ifndef EXTERN_C                  // sh. Basics.h
    #ifdef __cplusplus
      #define EXTERN_C extern "C"
    #else
      #define EXTERN_C extern
    #endif
  #endif

  EXTERN_C int conoutf(const char *fmt, ...);
  #define printf    conoutf
  #define PRINTF(p) {conoutf p;} 

  #define  PACKED

//  #define VAR_PTR_TO_CONST_TYP(Datentyp)   const Datentyp *
//  #define CONST_PTR_TO_CONST_TYP(Datentyp) const Datentyp * const
//  #define CONST_PTR_TO_VAR_TYP(Datentyp)         Datentyp * const
//  #define CONST_PTR_TO_XDATA(Datentyp)           Datentyp * const

  #define VAR_PTR_TO_CONST_TYP(Datentyp)     CODE  Datentyp *      
  #define CONST_PTR_TO_CONST_TYP(Datentyp)   CODE  Datentyp * CODE
  #define CONST_PTR_TO_VAR_TYP(Datentyp)           Datentyp * CODE
  #define CONST_PTR_TO_XDATA(Datentyp)             Datentyp * CODE



  #define U8_AUTO_VAR    unsigned long
  #define S8_AUTO_VAR    signed   long
  #define U16_AUTO_VAR   unsigned long
  #define S16_AUTO_VAR   signed   long


#else
  
/*   Weder ARM7 noch PMB7725 noch ZIELSIM ??? */
#error  Fehler: keine WORK_PLANE definiert !!!

#endif


// some typedefs due to symbolic NVM support
typedef char NV_STRING;
typedef unsigned char NV_BCD;
typedef unsigned char NV_BCD_DD;

#define nvm_struct struct
#define nvm_union  union


#endif     /* STDTYP_H */
